;------------------------------------------------------------------------------
; Used constants:
;
; C_LOCALTOSCREEN = local to screen matrix
;------------------------------------------------------------------------------
xvs.1.1

#include "ShadersConst.h"

#define V_POS      v0   ; position
#define V_COLOR    v1   ; color
#define V_NORM     v2   ; normal
#define V_TEX1     v3   ; tex1
#define V_TEX2     v4   ; tex2
#define V_TEX3     v5   ; tex3
#define V_TEX4     v6   ; tex4

; Transform the vertex to screen space
; The LOCALTOSCREEN matrix has to be transposed before.
dp4 oPos.x, V_POS, c[C_LOCALTOSCREEN+0]
dp4 oPos.y, V_POS, c[C_LOCALTOSCREEN+1]
dp4 oPos.z, V_POS, c[C_LOCALTOSCREEN+2]
dp4 oPos.w, V_POS, c[C_LOCALTOSCREEN+3]

; If we use that, we don't need to transpose the LOCALTOSCREEN matrix.
;mul r0, c[C_LOCALTOSCREEN+0], V_POS.x
;mad r0, c[C_LOCALTOSCREEN+1], V_POS.y, r0
;mad r0, c[C_LOCALTOSCREEN+2], V_POS.z, r0
;mad r0, c[C_LOCALTOSCREEN+3], V_POS.w, r0
;mov oPos, r0

mov	oD0,    V_COLOR
mov oT0.xy, V_TEX1
mov oT1.xy, V_TEX2
mov oT2.xy, V_TEX3
mov oT3.xy, V_TEX4

